<?php
// Array that holds all Page Options
// class is used to trigger some jQuery action

$custom_page_basic_meta_fields = array(
		array(
			'label'	=> 'Additional Page Title',
			'desc'	=> 'Leave blank for same as Page Title',
			'id'	=> $prefix.'header_title',
			'type'	=> 'text',
			'class' => 'tp_options content contact portfolio portfolio_blogview index index_full'
		),
		array(
			'label'	=> 'Select Slider',
			'desc'	=> 'Choose the Slider to this Page',
			'id'	=>  $prefix.'slider',
			'default' => '',
			'type'	=> 'slider_list',
			'class' => 'tp_options home_page contact'
		),
		array(
			'label'	=> 'Display Head Block?<div id=headblock_link style="display:none;"><a href="#headblock">Edit Head Block</a></div>',
			'text' => 'On/Off',
			'desc'	=> 'Show the special block with extra content on top of the page?',
			'id'	=> $prefix.'headline_active',
			'type'	=> 'checkbox',
			'default' => 'checked',
			'class' => 'tp_options headline '
		),
		array(
			'label'	=> 'Activate Sidebar<div id=sidebar_link style="display:none;"><a href="#sidebarblock">Edit Sidebar Options</a></div>',
			'text' => 'On/Off',
			'desc'	=> 'Use a sidebar or full view',
			'id'	=> $prefix.'activate_sidebar',
			'type'	=> 'checkbox',
			'default' => 'checked',
			'class' => 'tp_options content contact portfolio portfolio_blogview index index_full'
		),
		array(
			'label'	=> 'Use custom Page Background?<div id=background_link style="display:none;"><a href="#backgroundblock">Edit Background Options</a></div>',
			'text' => 'On/Off',
			'desc'	=> 'Use a Page Background different from the default in the alterego Options?',
			'id'	=> $prefix.'background_active',
			'type'	=> 'checkbox',
			'default' => 'checked',
			'class' => 'tp_options home_page content contact portfolio portfolio_blogview index index_full '
		),
		array(
			'label'	=> 'Page Items & Order<div id=teaser_link style="display:none;"><a href="#teaserblock">Edit Teaser Line</div><div id=taglines_link style="display:none;"><a href="#taglinesblock">Edit Taglines</div><div id=partners_link style="display:none;"><a href="#partnersblock">Edit Partners</div>',
			'desc'	=> 'Choose the Blocks',
			'id'	=>  $prefix.'home_teasers',
			'type'	=> 'home_list',
			'class' => 'tp_options home_page'
		),
);

function show_custom_page_basic_meta_fields_box(){
	global $custom_page_basic_meta_fields,$custom_meta_fields;
	$custom_meta_fields=$custom_page_basic_meta_fields;
	show_custom_meta_box();
}


$custom_page_head_meta_fields = array(
		array(
			'label'	=> 'Layout',
			'desc'	=> 'Column Layout of the Headbox',
			'id'	=> $prefix.'head_box_layout',
			'type'	=> 'select',
			'options' => array (
				'one_third-two_third' => array (
					'label' => 'One Third Title, Two Thirds Content',
					'value'	=> 'one_third-two_third'
				),
			'one_half-one_half' => array (
					'label' => 'One Half Title, One Half Content',
					'value'	=> 'one_half-one_half'
				),
			'two_third-one_third' => array (
					'label' => 'Two Thirds Title, One Third Content',
					'value'	=> 'two_third-one_third'
				),
			'one_third-two_third-button' => array (
					'label' => 'One Third Title, Two Thirds Content with Button',
					'value'	=> 'one_third-two_third-button'
				),

			),
			'class' => ''
		),
		array(
			'label'	=> '<a name=headblock></a>Title',
			'desc'	=> 'Title of the Head Box',
			'id'	=> $prefix.'head_box_title',
			'type'	=> 'textarea',
			'class' => ''
		),
		array(
			'label'	=> 'Content',
			'desc'	=> 'Content of the Head Box',
			'id'	=> $prefix.'head_box_content',
			'type'	=> 'textarea',
			'class' => ''
		),
		array(
			'label'	=> 'Button Type',
			'desc'	=> 'Basic or Purchase Button',
			'id'	=> $prefix.'head_box_button_type',
			'type'	=> 'select',
			'options' => array (
				'basic' => array (
					'label' => 'Basic',
					'value'	=> 'basic'
				),
			'purchase' => array (
					'label' => 'Purchase',
					'value'	=> 'purchase'
				)
			),
			'class' => 'head_button'
		),

			array(
			'label'	=> 'Button Text',
			'desc'	=> 'Text on Button',
			'id'	=> $prefix.'head_box_button_text',
			'type'	=> 'text',
			'class' => 'head_button'
		),
		array(
			'label'	=> 'Button URL',
			'desc'	=> 'Link on Button',
			'id'	=> $prefix.'head_box_button_link',
			'type'	=> 'text',
			'class' => 'head_button'
		)
	);

function show_custom_page_head_meta_fields_box(){
	global $custom_page_head_meta_fields,$custom_meta_fields;
	$custom_meta_fields=$custom_page_head_meta_fields;
	show_custom_meta_box();
}

$custom_page_teaser_meta_fields = array(
		array(
			'label'	=> '<a name=teaserblock></a>Title',
			'desc'	=> 'Title of the Head Box',
			'id'	=> $prefix.'teaser_title',
			'type'	=> 'text',
			'class' => ''
		),
		array (
			'label'	=> 'Teaser Type',
			'desc'	=> 'From what area do you want the teasers to be?',
			'id'	=> $prefix.'teasers_type',
			'type'	=> 'radio',
			'default' => 'Blog',
			'options' => array (
				'Blog' => array (
					'label' => 'Blog',
					'value'	=> 'blog'
				),
				'Portfolio' => array (
					'label' => 'Portfolio',
					'value'	=> 'portfolio'
				)
			),
			'class' => ''
		),
		array(
			'label'	=> 'Select Portfolio',
			'desc'	=> 'Choose the Portfolio to display',
			'id'	=>  $prefix.'teasers_portfolio',
			'type'	=> 'portfolio_list',
			'class' => 'teasers_portfolio'
		),
		array(
			'label'	=> 'Category',
			'desc'	=> 'Which Category?',
			'id'	=> $prefix.'teasers_category',
			'type'	=> 'category_list',
			'class' => ''
		),
		array(
			'label'	=> 'Category',
			'desc'	=> 'Which Category?',
			'id'	=> $prefix.'teasers_portfolio_category',
			'type'	=> 'text',
			'class' => ''
		),
		array(
			'label'	=> 'Max. Number of items',
			'desc'	=> 'How many teaser items maximum?',
			'id'	=> $prefix.'teasers_number',
			'type'	=> 'text',
			'class' => ''
		),
		array(
			'label'	=> 'Excerpt Length',
			'desc'	=> 'How many words of the excerpt in the Overview?',
			'id'	=> $prefix.'excerpt_number',
			'type'	=> 'text',
			'class' => ''
		)
);

function show_custom_page_teaser_meta_fields_box(){
	global $custom_page_teaser_meta_fields,$custom_meta_fields;
	$custom_meta_fields=$custom_page_teaser_meta_fields;
	show_custom_meta_box();
}

$custom_page_elements_meta_fields = array(
		array(
			'label'	=> '<a name=taglinesblock></a>Tagline Carousel Speed',
			'desc'	=> 'The duration a tagline content stays on the screen (ms)',
			'id'	=> $prefix.'carousel_speed',
			'type'	=> 'text',
			'class' => ' content portfolio index taglines'
		),
		array(
			'label'	=> 'Tagline Carousel Height (px)',
			'desc'	=> 'The height of the tagline area',
			'id'	=> $prefix.'carousel_height',
			'type'	=> 'text',
			'class' => ' content portfolio index taglines'
		),
		array(
			'label'	=> 'Taglines',
			'desc'	=> 'Put in the content (HTML, e.g. use &lt;br> for linebreaks) you want to see in the tagline area of the page',
			'id'	=> $prefix.'taglines',
			'type'	=> 'repeatable_taglines',
			'class' => ' content portfolio index taglines'
		)
);

function show_custom_page_elements_meta_fields_box(){
	global $custom_page_elements_meta_fields,$custom_meta_fields;
	$custom_meta_fields=$custom_page_elements_meta_fields;
	show_custom_meta_box();
}

$custom_page_partner_meta_fields = array(
		array(
			'label'	=> '<a name=partnerblock></a>Partners',
			'desc'	=> 'Insert a list of images to display in the partner area',
			'id'	=> $prefix.'partners',
			'type'	=> 'repeatable_partners',
			'class' => ' content portfolio index partners'
		),
		array(
			'id'	=> $prefix.'partners_link'
		)
);

function show_custom_partners_elements_meta_fields_box(){
	global $custom_page_partner_meta_fields,$custom_meta_fields;
	$custom_meta_fields=$custom_page_partner_meta_fields;
	show_custom_meta_box();
}

$custom_page_sidebar_meta_fields = array(
		array (
			'label'	=> '<a name=sidebarblock></a>Sidebar Orientation',
			'desc'	=> 'Places the sidebar left or right',
			'id'	=> $prefix.'sidebar_orientation',
			'type'	=> 'radio',
			'default' => 'right',
			'options' => array (
				'right' => array (
					'label' => 'Right',
					'value'	=> 'right'
				),
				'left' => array (
					'label' => 'Left',
					'value'	=> 'left'
				)
			),
			'class' => ' content contact portfolio portfolio_blogview index index_full  sidebar contact '
		),
		array(
			'label'	=> 'Select Sidebar',
			'desc'	=> 'Choose the Sidebar to this Page',
			'id'	=>  $prefix.'sidebar',
			'default' => 'Blog Sidebar',
			'type'	=> 'sidebar_list',
			'class' => ' content contact portfolio portfolio_blogview index index_full  sidebar contact'
		)
);

function show_custom_page_sidebar_meta_fields_box(){
	global $custom_page_sidebar_meta_fields,$custom_meta_fields;
	$custom_meta_fields=$custom_page_sidebar_meta_fields;
	show_custom_meta_box();
}

$custom_page_background_meta_fields = array(
		array(
			'label'	=> '<a name=backgroundblock></a>Page Background Image',
			'text' => 'On/Off',
			'desc'	=> 'Upload or Choose a page Background for the ground level',
			'id'	=> $prefix.'background_src',
			'type'	=> 'image',
			'default' => 'checked',
			'class' => ' content contact portfolio portfolio_blogview page_background index index_full  contact'
		),
		array (
			'label'	=> 'Page Background Image Style',
			'desc'	=> 'You want your image tiled(small pic repeated), stretched(the picture will be stretched to the edges of the window ignoring the aspect ratio) or fitted(the picture size will be set to fill the screen respecting the aspect ratio, could be you do not see the whole picture depending on window dimensions)?',
			'id'	=> $prefix.'background_type',
			'type'	=> 'radio',
			'default' => 'tiled',
			'options' => array (
				'tiled' => array (
					'label' => 'tiled',
					'value'	=> 'tiled'
				),
				'stretched' => array (
					'label' => 'stretch',
					'value'	=> 'stretch'
				),
				'fit-outside' => array (
					'label' => 'fit-outside',
					'value'	=> 'fit-outside'
				),
				'fit-inside' => array (
					'label' => 'fit-inside',
					'value'	=> 'fit-inside'
				)
			),
			'class' => ' content contact portfolio portfolio_blogview index index_full  page_background contact '
		),
		array(
			'label'	=> 'Page Background Tile',
			'text' => 'On/Off',
			'desc'	=> 'Upload or Choose a page Background for the top level',
			'id'	=> $prefix.'background_tile_src',
			'type'	=> 'image',
			'default' => 'checked',
			'class' => ' content contact portfolio portfolio_blogview page_background index index_full  contact'
		),
);


function show_custom_page_background_meta_fields_box(){
	global $custom_page_background_meta_fields,$custom_meta_fields;
	$custom_meta_fields=$custom_page_background_meta_fields;
	show_custom_meta_box();
}

$custom_page_portfolio_meta_fields = array(
		array(
			'label'	=> 'Select Portfolio',
			'desc'	=> 'Choose the Portfolio to display',
			'id'	=>  $prefix.'portfolio',
			'type'	=> 'portfolio_list',
			'class' => 'portfolio portfolio_blogview'
		),
		array (
			'label'	=> 'How many items per line?',
			'desc'	=> 'Choose how many items you want to display in one line',
			'id'	=> $prefix.'portfolio_rownumber',
			'type'	=> 'radio',
			'default' => '4',
			'options' => array (
				'four' => array (
					'label' => '4',
					'value'	=> '4'
				),
				'three' => array (
					'label' => '3',
					'value'	=> '3'
				)
			),
			'class' => 'portfolio'
		)
);

function show_custom_page_portfolio_meta_fields_box(){
	global $custom_page_portfolio_meta_fields,$custom_meta_fields;
	$custom_meta_fields=$custom_page_portfolio_meta_fields;
	show_custom_meta_box();
}

?>